<?php

/**
 * iCard Payment Plugin for VirtueMart
 * Legacy compatibility wrapper for Joomla 5.x
 * 
 * DEPENDENCIES:
 * - Joomla 5.x or 6.x
 * - VirtueMart 4.x (e-commerce component) - REQUIRED
 * - PHP 8.1+ with OpenSSL extension
 * 
 * IMPORTANT: This plugin is specifically designed for VirtueMart and cannot be used 
 * with other e-commerce extensions like HikaShop, J2Store, JoomShopping, or J2Commerce.
 * 
 * @author iCard Technologies Ltd.
 * @version 2.0.0
 * @package VirtueMart
 * @subpackage payment
 * @license GNU General Public License version 3 or later; see http://www.gnu.org/licenses/gpl-3.0.html
 */

defined('_JEXEC') or die('Restricted access');

// Load VirtueMart defines and constants FIRST
if (!function_exists('loadVirtueMartDefines')) {
    function loadVirtueMartDefines() {
        if (!defined('JPATH_VM_PLUGINS')) {
            // Load Joomla legacy compatibility for VirtueMart 4.4.4
            if (!class_exists('JFactory')) {
                require_once JPATH_ROOT . '/libraries/joomla/legacy/factory.php';
            }
            
            $vmdefines_path = JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/vmdefines.php';
            if (file_exists($vmdefines_path)) {
                require_once $vmdefines_path;
                \vmDefines::defines();
            }
        }
    }
}
loadVirtueMartDefines();

// Now load vmPSPlugin after constants are defined
if (!class_exists('vmPSPlugin')) {
    require(JPATH_VM_PLUGINS . DIRECTORY_SEPARATOR . 'vmpsplugin.php');
}

// Use the modern namespaced class
use Icard\Plugin\Vmpayment\Icard\Extension\Icard;

// Legacy wrapper class for backward compatibility
class plgVmpaymenticard extends Icard
{
    /**
     * Legacy constructor - redirect to modern namespaced class
     */
    function __construct(&$subject, $config)
    {
        // Convert legacy parameters to modern format
        $dispatcher = null;
        if (isset($subject)) {
            $dispatcher = $subject;
        }
        
        // Call parent constructor with modern parameters
        parent::__construct($dispatcher, $config);
    }
}